/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.CRC32;
import panther.util.general.ErrorUtils;
import panther.util.general.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final String TMP_DIRECTORY_PROPERTY = "java.io.tmpdir";
    public static final String USER_HOME_DIRECTORY_PROPERTY = "user.home";
    public static final File TMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    public static final File USER_HOME_DIRECTORY = new File(System.getProperty("user.home"));
    public static final Comparator<File> MODIFICATION_DATE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            if (file.lastModified() < file2.lastModified()) {
                return -1;
            }
            if (file.lastModified() > file2.lastModified()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<File> NAME_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            return file.getName().compareTo(file2.getName());
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };

    public static void appendToFile(File file, String string) throws Exception {
        IOUtils.copy(new StringReader(string), (Writer)new FileWriter(file, true));
    }

    public static long calculateCheckSum(File file) throws Exception {
        byte[] byArray = FileUtils.readFileAsBytes(file);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static void copyDirectory(File file, File file2) throws Exception {
        File file3 = new File(file2, file.getName());
        file3.mkdirs();
        FileUtils.copyDirectoryContents(file, file3);
    }

    public static void copyDirectoryContents(File file, File file2) throws Exception {
        for (File file3 : FileUtils.listFiles(file)) {
            File file4 = new File(file2, file3.getName());
            if (file3.isFile()) {
                FileUtils.copyFile(file3, file4);
                continue;
            }
            if (!FileUtils.isProperSubDirectory(file3, file)) continue;
            FileUtils.copyDirectory(file3, file4);
        }
    }

    public static void copyFile(File file, File file2) throws Exception {
        FileUtils.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl) throws Exception {
        if (bl) {
            FileUtils.mkParentDirs(file2);
        }
        IOUtils.copy((InputStream)new FileInputStream(file), new FileOutputStream(file2));
    }

    public static void copyFiles(File file, File file2, FilenameFilter filenameFilter) throws Exception {
        for (File file3 : FileUtils.listFiles(file, filenameFilter)) {
            File file4 = new File(file2, file3.getName());
            if (!file3.isFile()) continue;
            FileUtils.copyFile(file3, file4);
        }
    }

    public static File copyFileToDirectory(File file, File file2) throws Exception {
        File file3 = new File(file2, file.getName());
        FileUtils.copyFile(file, file3);
        return file3;
    }

    public static boolean deleteDirectory(File file) throws Exception {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            throw new Error("FileUtils.deleteDirectory called on file " + FileUtils.safeGetCanonicalPath(file));
        }
        boolean bl = FileUtils.deleteDirectoryContents(file);
        if (bl) {
            bl = file.delete();
        }
        return bl;
    }

    public static boolean deleteDirectoryContents(File file) throws Exception {
        boolean bl = true;
        for (File file2 : FileUtils.listFiles(file)) {
            if (file2.isFile()) {
                if (file2.delete()) continue;
                bl = false;
                continue;
            }
            if (!FileUtils.isProperSubDirectory(file2, file) || FileUtils.deleteDirectoryContents(file2)) continue;
            bl = false;
        }
        return bl;
    }

    public static List<File> getContentsInModificationDateOrder(File file) throws Exception {
        return FileUtils.getContentsInOrder(file, MODIFICATION_DATE_COMPARATOR);
    }

    public static List<File> getContentsInNameOrder(File file) throws Exception {
        return FileUtils.getContentsInOrder(file, NAME_COMPARATOR);
    }

    public static List<File> getContentsInOrder(File file, Comparator comparator) throws Exception {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : FileUtils.listFiles(file)) {
            if (!file2.isFile() && !FileUtils.isProperSubDirectory(file2, file)) continue;
            arrayList.add(file2);
        }
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static List<File> getFilesInModificationDateOrder(File file) throws Exception {
        return FileUtils.getFilesInOrder(file, MODIFICATION_DATE_COMPARATOR);
    }

    public static List<File> getFilesInNameOrder(File file) throws Exception {
        return FileUtils.getFilesInOrder(file, NAME_COMPARATOR);
    }

    public static List<File> getFilesInOrder(File file, Comparator comparator) throws Exception {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : FileUtils.listFiles(file)) {
            if (!file2.isFile()) continue;
            arrayList.add(file2);
        }
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static List<File> getSubDirectoriesInModificationDateOrder(File file) throws Exception {
        return FileUtils.getSubDirectoriesInOrder(file, MODIFICATION_DATE_COMPARATOR);
    }

    public static List<File> getSubDirectoriesInNameOrder(File file) throws Exception {
        return FileUtils.getSubDirectoriesInOrder(file, NAME_COMPARATOR);
    }

    public static List<File> getSubDirectoriesInOrder(File file, Comparator comparator) throws Exception {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : FileUtils.listFiles(file)) {
            if (!FileUtils.isProperSubDirectory(file2, file)) continue;
            arrayList.add(file2);
        }
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static boolean isProperSubDirectory(File file, File file2) {
        File file3 = file.getParentFile();
        return file.isDirectory() && file3 != null && file3.equals(file2);
    }

    public static File[] listFiles(File file) throws Exception {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (file == null) {
                throw new IOException("Attempt to list files from a null directory");
            }
            if (!file.exists()) {
                throw new IOException("Attempt to list files from a non-existing directory: " + FileUtils.safeGetCanonicalPath(file));
            }
            if (!file.isDirectory()) {
                throw new IOException("Attempt to list files from a non-directory: " + FileUtils.safeGetCanonicalPath(file));
            }
            throw new IOException("Unable to list files from " + FileUtils.safeGetCanonicalPath(file));
        }
        return fileArray;
    }

    public static File[] listFiles(File file, FilenameFilter filenameFilter) throws Exception {
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            if (file == null) {
                throw new IOException("Attempt to list files from a null directory");
            }
            if (!file.exists()) {
                throw new IOException("Attempt to list files from a non-existing directory: " + FileUtils.safeGetCanonicalPath(file));
            }
            if (!file.isDirectory()) {
                throw new IOException("Attempt to list files from a non-directory: " + FileUtils.safeGetCanonicalPath(file));
            }
            throw new IOException("Unable to list files from " + FileUtils.safeGetCanonicalPath(file));
        }
        return fileArray;
    }

    public static void mkParentDirs(File file) throws Exception {
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
    }

    public static File moveDirectory(File file, File file2) throws Exception {
        boolean bl = false;
        try {
            bl = file.renameTo(file2);
        }
        catch (Throwable throwable) {
            ErrorUtils.check(throwable);
            bl = false;
        }
        if (bl) {
            return file2;
        }
        file2.mkdirs();
        FileUtils.deleteDirectoryContents(file2);
        FileUtils.copyDirectoryContents(file, file2);
        return file2;
    }

    public static File moveFile(File file, File file2) throws Exception {
        boolean bl = false;
        try {
            bl = file.renameTo(file2);
        }
        catch (Throwable throwable) {
            ErrorUtils.check(throwable);
            bl = false;
        }
        if (bl) {
            return file2;
        }
        FileUtils.mkParentDirs(file2);
        FileUtils.copyFile(file, file2);
        file.delete();
        return file2;
    }

    public static File moveFileToDirectory(File file, File file2) throws Exception {
        return FileUtils.moveFile(file, new File(file2, file.getName()));
    }

    public static byte[] readFileAsBytes(File file) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)new FileInputStream(file), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String readFileAsString(File file) throws Exception {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(new FileReader(file), (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String readFileAsString(String string) throws Exception {
        return FileUtils.readFileAsString(new File(string));
    }

    public static String safeGetCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Throwable throwable) {
            ErrorUtils.check(throwable);
            try {
                return file.getName();
            }
            catch (Throwable throwable2) {
                ErrorUtils.check(throwable2);
                try {
                    return file.toString();
                }
                catch (Throwable throwable3) {
                    ErrorUtils.check(throwable3);
                    return "unknown file";
                }
            }
        }
    }

    public static void writeFile(File file, String string) throws Exception {
        IOUtils.copy(new StringReader(string), (Writer)new FileWriter(file));
    }

    public static void writeFile(File file, byte[] byArray) throws Exception {
        IOUtils.copy((InputStream)new ByteArrayInputStream(byArray), new FileOutputStream(file));
    }
}

